// CThread.h: interface for the CThread class.
//
//////////////////////////////////////////////////////////////////////
#if !defined(AFX_THREAD_H__3B8233A5_A65F_4457_B895_8C5EA45DA924__INCLUDED_)
#define AFX_THREAD_H__3B8233A5_A65F_4457_B895_8C5EA45DA924__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
/////////////////////////////////////////////////////////////////////////////
#ifdef COMMON_EXPORTS
	#define COMMON_API __declspec(dllexport)
#else
	#define COMMON_API __declspec(dllimport)
#endif
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "VPIncs.h"
/////////////////////////////////////////////////////////////////////////////
#define TIMEOUT_INFINITE            0xFFFFFFFF
/////////////////////////////////////////////////////////////////////////////
typedef enum
{
	kUninited=0,
	kStarting,
	kRunning,
	kStoping,
	kCompleted,
} ThreadState;
/////////////////////////////////////////////////////////////////////////////
class COMMON_API CThread  
{
private:
	Bool				mSuspended;
public:
	UInt8				mThreadState;
	void *				mThreadHandle;
	DWORD				mThreadId;

public:
	CThread();
	virtual ~CThread();
	virtual void		DoAction()=0;

	Bool				SetPriority(int iPriority);
	Bool				Start();
	Bool				Stop();
	static DWORD WINAPI InternalThreadProc( LPVOID aThread );

	Bool IsRunning()	{ return mThreadState == kRunning; };
	Bool IsStarting()	{ return mThreadState == kStarting; };
	Bool IsSuspended()	{ return mSuspended; };

	Bool				PauseThread(UInt32 timeOutMs);
	DWORD				Suspend();
	DWORD				Resume();
	Bool				WaitForCompletion(UInt32 aDelay,UInt32 *aReason);
};



/////////////////////////////////////////////////////////////////////////////


#endif // !defined(AFX_THREAD_H__3B8233A5_A65F_4457_B895_8C5EA45DA924__INCLUDED_)
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////